/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIHSCSysProfClient;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class PISystemStateChange {
    private static final int NUM_VALID_PARMS = 15;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_frame;
    private String m_operation;
    private String m_resourceName;
    private String m_partitionID;
    private String m_actProfName;
    private String m_bootMode;
    private String m_keylockSetting;
    private String m_validate;
    private String m_continue;
    private String m_immed;
    private String m_reboot;
    private UnsignedInt8 m_hpt = null;
    private String m_iplSrc;
    private HashMap m_validParms = new HashMap(31, 0.5f);
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFrameClient m_FrameClient = null;
    private static final String CHANGE_KEYLOCK_OPERATION = "chkey";
    private static final String ON_OPERATION = "on";
    private static final String ON_STANDBY_OPERATION = "onstandby";
    private static final String ON_SYSPROF_OPERATION = "onsysprof";
    private static final String OFF_OPERATION = "off";
    private static final String RESET_OPERATION = "dumprestart";
    private static final String REBUILD_OPERATION = "rebuild";
    private static final String RECOVER_OPERATION = "recover";
    private static final String SHUTDOWN_OPERATION = "shutdown";
    private static final String OS_SHUTDOWN_OPERATION = "osshutdown";
    private static final String DST_ON_OPERATION = "dston";
    private static final String RETRY_OPERATION = "retrydump";
    private static final String REMOTE_DST_OFF_OPERATION = "remotedstoff";
    private static final String REMOTE_DST_ON_OPERATION = "remotedston";
    private static final String IOP_RESET_OPERATION = "iopreset";
    private static final String IOP_DUMP_OPERATION = "iopdump";
    private static final String CLEAR_IO_TABLE_OPERATION = "cleariotable";
    private static final String UNOWNED_IO_OFF_OPERATION = "unownediooff";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PISystemStateChange(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_FrameClient = pIHSCFrameClient;
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-o", null);
        this.m_validParms.put("-n", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-b", null);
        this.m_validParms.put("-k", null);
        this.m_validParms.put("--test", null);
        this.m_validParms.put("--continue", null);
        this.m_validParms.put("--immed", null);
        this.m_validParms.put("--restart", null);
        this.m_validParms.put("-i", null);
        this.m_validParms.put("--hptratioexp", null);
        this.m_validParms.put("-e", null);
    }

    private void doSystemOperations() throws PIHscClientException {
        short s;
        if (ON_OPERATION.equals(this.m_operation)) {
            if (this.m_keylockSetting != null) {
                this.doChangeSysKeylock();
            }
            this.m_CECClient.powerOnWithOptions(2, new String("NoSysProf"), new Boolean(false), new Boolean(false));
        } else if (ON_STANDBY_OPERATION.equals(this.m_operation)) {
            this.m_CECClient.powerOnWithOptions(1, new String("NoSysProf"), new Boolean(false), new Boolean(false));
        } else if (ON_SYSPROF_OPERATION.equals(this.m_operation)) {
            if (this.m_keylockSetting != null) {
                this.doChangeSysKeylock();
            }
            this.m_CECClient.powerOnWithOptions(3, this.m_actProfName, new Boolean(false), new Boolean(false));
        } else if (OFF_OPERATION.equals(this.m_operation)) {
            if (this.m_immed != null) {
                if (this.m_reboot != null) {
                    this.m_CECClient.reIPL();
                } else {
                    this.m_CECClient.fastPowerOff();
                }
            } else {
                this.m_CECClient.powerOff();
            }
        } else if (REBUILD_OPERATION.equals(this.m_operation)) {
            this.m_CECClient.rebuild();
        } else if (RECOVER_OPERATION.equals(this.m_operation)) {
            this.doRecoverOperation();
        } else if (CHANGE_KEYLOCK_OPERATION.equals(this.m_operation)) {
            this.doChangeSysKeylock();
        } else if (CLEAR_IO_TABLE_OPERATION.equals(this.m_operation) && (s = this.m_CECClient.clearIotable()) != 0) {
            throw new PIHscClientException(null);
        }
    }

    private void doFrameOperations() throws PIHscClientException {
        if (this.m_frame == null) {
            return;
        }
        if (REBUILD_OPERATION.equals(this.m_operation)) {
            this.m_FrameClient.rebuild();
        } else if (UNOWNED_IO_OFF_OPERATION.equals(this.m_operation)) {
            this.m_FrameClient.powerOffUnownedDrawers();
        }
    }

    private void doRecoverOperation() throws PIHscClientException {
        Vector<String> vector = new Vector<String>();
        String string = this.m_CECClient.getIntName();
        String string2 = string.substring(string.indexOf("*") + 1, string.length());
        String string3 = "/var/hsc/profiles/" + string2 + "/" + "backupFile";
        vector.add(string3);
        this.m_CECClient.profileDataOps((short)6, vector);
    }

    private void doChangeSysKeylock() throws PIHscClientException {
        UnsignedInt8 unsignedInt8 = "norm".equals(this.m_keylockSetting) ? new UnsignedInt8(4) : new UnsignedInt8(2);
        PICECDataBean pICECDataBean = new PICECDataBean();
        pICECDataBean.setPlatformNextKeylockPos(unsignedInt8);
        this.m_CECClient.setCECDataBean(pICECDataBean);
    }

    private void doPartitionOperations() throws PIHscClientException {
        PIHSCLPARClient pIHSCLPARClient = null;
        pIHSCLPARClient = this.m_resourceName != null ? this.m_factory.createLPARClient(this.m_managedSystem, this.m_resourceName, false) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partitionID, true);
        if (pIHSCLPARClient == null) {
            if (this.m_resourceName != null) {
                String[] stringArray = new String[]{this.m_resourceName};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
            String[] stringArray = new String[]{this.m_partitionID};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
        }
        if (ON_OPERATION.equals(this.m_operation)) {
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
            UnsignedInt8 unsignedInt82 = new UnsignedInt8(255);
            UnsignedInt8 unsignedInt83 = new UnsignedInt8(255);
            if (this.m_keylockSetting != null) {
                unsignedInt8 = "norm".equals(this.m_keylockSetting) ? new UnsignedInt8(4) : new UnsignedInt8(2);
            }
            if (this.m_iplSrc != null) {
                unsignedInt82 = PIHMCCommandUtils.decodeIplSourceString(this.m_iplSrc);
            }
            if (this.m_bootMode != null) {
                unsignedInt83 = PIHMCCommandUtils.decodeBootModeString(this.m_bootMode);
            }
            pIHSCLPARClient.powerOn(this.m_actProfName, unsignedInt83, unsignedInt82, unsignedInt8, this.m_hpt);
        } else if (OS_SHUTDOWN_OPERATION.equals(this.m_operation)) {
            if (this.m_immed != null) {
                if (this.m_reboot != null) {
                    pIHSCLPARClient.osShutdown(new Boolean(true), new Boolean(true));
                } else {
                    pIHSCLPARClient.osShutdown(new Boolean(true), new Boolean(false));
                }
            } else if (this.m_reboot != null) {
                pIHSCLPARClient.osShutdown(new Boolean(false), new Boolean(true));
            } else {
                pIHSCLPARClient.osShutdown(new Boolean(false), new Boolean(false));
            }
        } else if (SHUTDOWN_OPERATION.equals(this.m_operation)) {
            if (this.m_immed != null) {
                if (this.m_reboot != null) {
                    pIHSCLPARClient.reIPL();
                } else {
                    pIHSCLPARClient.emergencyPowerOff();
                }
            } else if (this.m_reboot != null) {
                pIHSCLPARClient.dumpToLoad("0");
            } else {
                pIHSCLPARClient.powerOff();
            }
        } else if (DST_ON_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.forceDST();
        } else if (RESET_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.dumpToLoad("0");
        } else if (RETRY_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.retryMSDIPL();
        } else if (REMOTE_DST_OFF_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.enableDST("0");
        } else if (REMOTE_DST_ON_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.enableDST("1");
        } else if (IOP_RESET_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.diskIOP("0");
        } else if (IOP_DUMP_OPERATION.equals(this.m_operation)) {
            pIHSCLPARClient.dumpToLoad("1");
        } else if (CHANGE_KEYLOCK_OPERATION.equals(this.m_operation)) {
            this.doChangePartitionKeylock(pIHSCLPARClient);
        }
    }

    private void doChangePartitionKeylock(PIHSCLPARClient pIHSCLPARClient) throws PIHscClientException {
        UnsignedInt8 unsignedInt8 = "norm".equals(this.m_keylockSetting) ? new UnsignedInt8(4) : new UnsignedInt8(2);
        PILPARDataBean pILPARDataBean = new PILPARDataBean();
        pILPARDataBean.setKeylock(unsignedInt8);
        pIHSCLPARClient.setLPARDataBean(pILPARDataBean);
    }

    private void doChangePartitionIPLSrc(PIHSCLPARClient pIHSCLPARClient) throws PIHscClientException {
        UnsignedInt8 unsignedInt8 = PIHMCCommandUtils.decodeIplSourceString(this.m_iplSrc);
        System.out.println("iplSrc = " + unsignedInt8);
        PILPARDataBean pILPARDataBean = new PILPARDataBean();
        pILPARDataBean.setIplSource(unsignedInt8);
        pIHSCLPARClient.setLPARDataBean(pILPARDataBean);
    }

    private void doSysProfOperations() throws PIHscClientException {
        PIHSCSysProfClient pIHSCSysProfClient = this.m_factory.createSysProfClient(this.m_CECClient, this.m_resourceName);
        if (pIHSCSysProfClient == null) {
            String[] stringArray = new String[]{this.m_resourceName};
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8010", stringArray, null);
        }
        if (this.m_operation != null) {
            boolean bl;
            boolean bl2 = this.m_continue == null;
            boolean bl3 = bl = this.m_validate != null;
            if (!pIHSCSysProfClient.activateSysProf(bl2, bl)) {
                String string = pIHSCSysProfClient.getValidationMsg();
                if (this.m_writeStatus) {
                    this.m_out.print('\u0001');
                    this.m_writeStatus = false;
                }
                this.m_out.println(string);
            }
        } else if (!pIHSCSysProfClient.validateSysProf()) {
            String string = pIHSCSysProfClient.getValidationMsg();
            if (this.m_writeStatus) {
                this.m_out.print('\u0001');
                this.m_writeStatus = false;
            }
            this.m_out.println(string);
        } else {
            String string = pIHSCSysProfClient.getValidationMsg();
            if (this.m_writeStatus) {
                this.m_out.print('\u0000');
                this.m_writeStatus = false;
            }
            this.m_out.println(string);
        }
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        if (this.m_CECClient != null) {
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
            int n = pICECDataBean.getCecState().intValue();
            if ("lpar".equals(this.m_resourceType)) {
                if (ON_OPERATION.equals(this.m_operation)) {
                    if (n != 17 && n != 1) {
                        throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
                    }
                } else if (n != 1) {
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0238", null, null);
                }
            } else if ("sysprof".equals(this.m_resourceType)) {
                if (n != 17 && n != 1) {
                    throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
                }
            } else if (RECOVER_OPERATION.equals(this.m_operation) && n != 251) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
            }
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        if ("sys".equals(this.m_resourceType)) {
            this.doSystemOperations();
        } else if ("lpar".equals(this.m_resourceType)) {
            this.doPartitionOperations();
        } else if ("frame".equals(this.m_resourceType)) {
            this.doFrameOperations();
        } else {
            this.doSysProfOperations();
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType == null || !"sys".equals(this.m_resourceType) && !"frame".equals(this.m_resourceType) && !"lpar".equals(this.m_resourceType) && !"sysprof".equals(this.m_resourceType)) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (!("sysprof".equals(this.m_resourceType) || this.m_operation != null && this.isValidOperation(this.m_operation, this.m_resourceType))) {
            String[] stringArray = new String[]{"-o"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ("frame".equals(this.m_resourceType) && this.m_managedSystem != null) {
            String[] stringArray = new String[]{"-m", this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
        if (!"frame".equals(this.m_resourceType) && this.m_frame != null) {
            String[] stringArray = new String[]{"-e", this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
        string = "";
        if ("sys".equals(this.m_resourceType)) {
            if (ON_SYSPROF_OPERATION.equals(this.m_operation) && (this.m_actProfName == null || this.m_actProfName.length() == 0)) {
                string = string + ", -f";
            }
            if (CHANGE_KEYLOCK_OPERATION.equals(this.m_operation) && this.m_keylockSetting == null) {
                string = string + ", -k";
            }
        } else if ("lpar".equals(this.m_resourceType)) {
            if (!(this.m_resourceName != null && this.m_resourceName.length() != 0 || this.m_partitionID != null && this.m_partitionID.length() != 0)) {
                string = string + ", -n | --id";
            }
            if (ON_OPERATION.equals(this.m_operation) && (this.m_actProfName == null || this.m_actProfName.length() == 0)) {
                string = string + ", -f";
            }
            if (CHANGE_KEYLOCK_OPERATION.equals(this.m_operation) && this.m_keylockSetting == null) {
                string = string + ", -k";
            }
        } else if ("sysprof".equals(this.m_resourceType)) {
            if (this.m_resourceName == null || this.m_resourceName.length() == 0) {
                string = string + ", -n";
            }
            if (this.m_operation == null && this.m_validate == null) {
                string = string + ", -o | --test";
            }
            if (this.m_operation != null && !this.isValidOperation(this.m_operation, this.m_resourceType)) {
                string = string + ", -o";
            }
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        string = "";
        if ("lpar".equals(this.m_resourceType) && this.m_resourceName != null && this.m_partitionID != null) {
            string = "[-n | --id]";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        string = "";
        if (!"lpar".equals(this.m_resourceType) && this.m_partitionID != null) {
            string = string + ", --id";
        }
        if (!"sysprof".equals(this.m_resourceType)) {
            if (this.m_validate != null) {
                string = string + ", --test";
            }
            if (this.m_continue != null) {
                string = string + ", --continue";
            }
        }
        if (!"lpar".equals(this.m_resourceType) && !"sysprof".equals(this.m_resourceType) && this.m_resourceName != null) {
            string = string + ", -n";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string, this.m_resourceType};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
        }
        string = "";
        if (!(!"sysprof".equals(this.m_resourceType) && ("sys".equals(this.m_resourceType) && ON_SYSPROF_OPERATION.equals(this.m_operation) || "lpar".equals(this.m_resourceType) && ON_OPERATION.equals(this.m_operation)) || this.m_actProfName == null)) {
            string = string + ", -f";
        }
        if (!(("sys".equals(this.m_resourceType) || "lpar".equals(this.m_resourceType)) && ON_OPERATION.equals(this.m_operation) || this.m_bootMode == null)) {
            string = string + ", -b";
        }
        if (!("lpar".equals(this.m_resourceType) && ON_OPERATION.equals(this.m_operation) || this.m_hpt == null)) {
            string = string + ", --hptratioexp";
        }
        if (!"sys".equals(this.m_resourceType) && !"lpar".equals(this.m_resourceType) || !OFF_OPERATION.equals(this.m_operation) && !SHUTDOWN_OPERATION.equals(this.m_operation) && !OS_SHUTDOWN_OPERATION.equals(this.m_operation)) {
            if (this.m_immed != null) {
                string = string + ", --immed";
            }
            if (this.m_reboot != null) {
                string = string + ", --restart";
            }
        }
        if (("sysprof".equals(this.m_resourceType) || "frame".equals(this.m_resourceType) || !ON_OPERATION.equals(this.m_operation) && !ON_SYSPROF_OPERATION.equals(this.m_operation) && !CHANGE_KEYLOCK_OPERATION.equals(this.m_operation)) && this.m_keylockSetting != null) {
            string = string + ", -k";
        }
        if (("sysprof".equals(this.m_resourceType) || "frame".equals(this.m_resourceType) || !ON_OPERATION.equals(this.m_operation)) && this.m_iplSrc != null) {
            string = string + ", -i";
        }
        if (!"sysprof".equals(this.m_resourceType) && this.m_continue != null || this.m_operation == null && this.m_continue != null) {
            string = string + ", --continue";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
        }
        if ("sys".equals(this.m_resourceType) && this.m_immed == null && this.m_reboot != null) {
            String[] stringArray = new String[]{"--restart", "--immed"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "COMMAND_LINE_ERROR_ONLY_WITH", stringArray, null);
        }
        if (this.m_keylockSetting != null && !"norm".equals(this.m_keylockSetting) && !"manual".equals(this.m_keylockSetting)) {
            String[] stringArray = new String[]{"-k"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (!(this.m_iplSrc == null || "a".equals(this.m_iplSrc) || "b".equals(this.m_iplSrc) || "c".equals(this.m_iplSrc) || "d".equals(this.m_iplSrc))) {
            String[] stringArray = new String[]{"-i"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private boolean isValidOperation(String string, String string2) {
        boolean bl = false;
        if ("sys".equals(string2)) {
            if (ON_OPERATION.equals(string) || ON_STANDBY_OPERATION.equals(string) || ON_SYSPROF_OPERATION.equals(string) || OFF_OPERATION.equals(string) || REBUILD_OPERATION.equals(string) || RECOVER_OPERATION.equals(string) || CHANGE_KEYLOCK_OPERATION.equals(string) || CLEAR_IO_TABLE_OPERATION.equals(string)) {
                bl = true;
            }
        } else if ("frame".equals(string2)) {
            if (REBUILD_OPERATION.equals(string) || UNOWNED_IO_OFF_OPERATION.equals(string)) {
                bl = true;
            }
        } else if ("lpar".equals(string2)) {
            if (ON_OPERATION.equals(string) || DST_ON_OPERATION.equals(string) || IOP_RESET_OPERATION.equals(string) || IOP_DUMP_OPERATION.equals(string) || RESET_OPERATION.equals(string) || RETRY_OPERATION.equals(string) || REMOTE_DST_OFF_OPERATION.equals(string) || REMOTE_DST_ON_OPERATION.equals(string) || OS_SHUTDOWN_OPERATION.equals(string) || SHUTDOWN_OPERATION.equals(string) || CHANGE_KEYLOCK_OPERATION.equals(string)) {
                bl = true;
            }
        } else if (ON_OPERATION.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_operation = (String)hashMap.get("-o");
        this.m_resourceName = (String)hashMap.get("-n");
        this.m_partitionID = (String)hashMap.get("--id");
        this.m_actProfName = (String)hashMap.get("-f");
        this.m_bootMode = (String)hashMap.get("-b");
        this.m_keylockSetting = (String)hashMap.get("-k");
        this.m_validate = (String)hashMap.get("--test");
        this.m_continue = (String)hashMap.get("--continue");
        this.m_immed = (String)hashMap.get("--immed");
        this.m_reboot = (String)hashMap.get("--restart");
        this.m_iplSrc = (String)hashMap.get("-i");
        String string = (String)hashMap.get("--hptratioexp");
        this.m_frame = (String)hashMap.get("-e");
        if (string != null) {
            try {
                this.m_hpt = new UnsignedInt8(string);
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = new String[]{"--hptratioexp"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        }
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        if ("sys".equals(this.m_resourceType) && this.m_resourceName != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHSYSSTATE_N_SYS_PARM", null, null);
        }
        if ("lpar".equals(this.m_resourceType) && OFF_OPERATION.equals(this.m_operation)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_CHSYSSTATE_OFF_LPAR_OPERATION", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHSYSSTATE_HELP_GA3"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemStateChange pISystemStateChange = new PISystemStateChange(pIHSCFrameClient, pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemStateChange.m_validParms);
            pISystemStateChange.mapParameters(hashMap);
            pISystemStateChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

